<?php
/*
Plugin Name: VK FullSite Installer
Description: 選んだデモサイトデータを数ステップでインポートして再現できるプラグインです。
Version: 0.5.0.0
Author: Vektor,Inc.
Author URI: https://vektor-inc.co.jp
Plugin URI: https://vk-fullsite-installer.com
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

// メモリ制限を設定
$target_memory = '512M';
if ( function_exists( 'ini_get' ) && function_exists( 'ini_set' ) ) {
    $current = ini_get( 'memory_limit' );
    if ( function_exists( 'wp_convert_hr_to_bytes' ) ) {
        if ( wp_convert_hr_to_bytes( $current ) < wp_convert_hr_to_bytes( $target_memory ) ) {
            @ini_set( 'memory_limit', $target_memory );
        }
    } else {
        @ini_set( 'memory_limit', $target_memory );
    }
}

// バッファリング開始
add_action( 'init', 'vkfsi_buffering' );
function vkfsi_buffering() {
	ob_start();
}

/**
 * Composer autoload
 */
$autoload_path = plugin_dir_path( __FILE__ ) . 'vendor/autoload.php';
// vendor ディレクトリがない状態で誤配信された場合に Fatal Error にならないようにファイルの存在確認.
if ( file_exists( $autoload_path ) ) {
	require_once $autoload_path;
}

use VektorInc\FullSiteInstaller\Installer;
Installer::init();

/**
 * Plugin Update Checker
 */
if ( class_exists( 'YahnisElsts\PluginUpdateChecker\v5\PucFactory' ) ) {
	$myUpdateChecker = YahnisElsts\PluginUpdateChecker\v5\PucFactory::buildUpdateChecker( // phpcs:ignore.
		'https://license.vektor-inc.co.jp/check/?action=get_metadata&slug=vk-fullsite-installer',
		__FILE__,
		'vk-fullsite-installer'
	);
}

// 管理画面にメニューを追加
add_action( 'admin_menu', 'vkfsi_add_admin_menu' );
function vkfsi_add_admin_menu() {
	add_options_page( 'VK FullSite Installer 設定', 'VK FullSite Installer', 'manage_options', 'vk-fullsite-installer', array( Installer::class, 'execute' ) );
}

// 初回起動時にリダイレクト
register_activation_hook( __FILE__, 'vkfsi_activate' );
add_action( 'admin_init', 'vkfsi_redirect_to_import_page' );

function vkfsi_activate() {
	add_option( 'vkfsi_do_activation_redirect', true );
}

function vkfsi_redirect_to_import_page() {
	if ( get_option( 'vkfsi_do_activation_redirect', false ) ) {
		delete_option( 'vkfsi_do_activation_redirect' );
		if ( ! isset( $_GET[ 'activate-multi' ] ) && ! isset( $_GET[ 'imported' ] ) ) {
			wp_redirect( admin_url( 'options-general.php?page=vk-fullsite-installer' ) );
			exit;
		}
	}
}

/**
 * プラグイン一覧画面に「設定」リンクを追加
 * @param array $links プラグインのアクションリンク
 * @return array 更新されたアクションリンク
 */
function vkfsi_settings_link( $links ) {
	$settings_link = '<a href="options-general.php?page=vk-fullsite-installer">' . __( 'Settings', 'default' ) . '</a>';
	array_unshift( $links, $settings_link ); // 先頭に追加
	return $links;
}

add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), 'vkfsi_settings_link' );
